/*
 * Actor.h
 *
 * Created 8/1/2009 By Johnny Huynh
 *
 * Version 00.00.01 8/1/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef ACTOR_H
 #define ACTOR_H
 
 template <typename T> class Actor;
 
 #include "Object.h"
 
 // For model animations
 #include "auto_bind.h" 
 #include "animControlCollection.h"
 #include "cIntervalManager.h"
 #include "cLerpNodePathInterval.h"
 #include "cMetaInterval.h"
 
 #include "global.h"
 
 /**
  * Class specification for Actor (animate object)
  */
 template <typename T>
 class Actor : virtual public Object<T>
 {
 // Data Members
 private:
    AnimControlCollection _anim_collection;
 
 // Local Functions
 public:
    Actor();
    Actor( const Actor<T>& a );
    virtual ~Actor();
    inline Actor<T>& operator=( const Actor<T>& a );
    virtual inline AnimControlCollection& get_anims();
    
    // overloaded functions (NodePath)
    /*static void init_type() {
                                std::string template_type( typeid( T ).name() );
                                register_type(_type_handle, "Actor<" + template_type + ">" );
                            }*/
 
 // Private Functions
 private:
    
 // Friend Functions
 public:
    
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 Actor<T>::Actor()
          : Object<T>()
 {
    
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 Actor<T>::Actor( const Actor<T>& a )
          : Object<T>( static_cast< Object<T> >( a ) ),
            _anim_collection( a._anim_collection )
 {
 
 }
 
 /**
  * Destructor
  */
 template <typename T>
 Actor<T>::~Actor()
 {
    // This should automatically happen
    //_anim_collection.clear_anims();
 }
 
 /**
  * operator=() copies the content of the specified Actor to this Actor.
  *
  * @param (const Actor<T>& a )
  * @return Actor<T>&
  */
 template <typename T>
 inline Actor<T>& Actor<T>::operator=( const Actor<T>& a )
 {
    Object<T>::operator=( static_cast< Object<T> >( a ) );
    _anim_collection = a._anim_collection;
    
    return *this;
 }
 
 /**
  * get_anims() returns the AnimControlCollection of this Actor.
  *
  * @return AnimControlCollection&
  */
 template <typename T>
 inline AnimControlCollection& Actor<T>::get_anims()
 {
    return _anim_collection;
 }
 
 /** FRIEND FUNCTIONS **/
 
 #endif // ACTOR_H